import os
import json

# Liste der Items (ohne .png-Endung)
items_list = [
    "emerald_hammer", "Girl_boots", "Girl_helmet", "Girl_leggings", "girl", "Girl_sword",
    "netherite_hammer", "reinforced_obsidian", "wooden_hammer", "Girl_axe", "Girl_chestplate",
    "Girl_hoe", "girl_pickaxe", "Girl_shovel", "iron_hammer", "obsidian_hammer", "stone_hammer"
]

# Sicherstellen, dass die Ordner existieren
os.makedirs("items", exist_ok=True)
os.makedirs("models/item", exist_ok=True)
os.makedirs("textures/item", exist_ok=True)

# JSON-Dateien erstellen
for item in items_list:
    # items/[item].json
    items_json = {
        "model": {
            "type": "minecraft:model",
            "model": f"freebuild:item/{item}"
        }
    }
    with open(f"items/{item}.json", "w", encoding="utf-8") as f:
        json.dump(items_json, f, indent=2, ensure_ascii=False)

    # models/item/[item].json
    models_json = {
        "parent": "item/handheld",
        "textures": {
            "layer0": f"freebuild:item/{item}"
        }
    }
    with open(f"models/item/{item}.json", "w", encoding="utf-8") as f:
        json.dump(models_json, f, indent=2, ensure_ascii=False)
